package com.hero.objects.powers;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Shrinking extends Power {

	private static String xmlID = "SHRINKING";

	public Shrinking(Element root) {
		super(root, Shrinking.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " (" + getPlainDamageDisplay() + ")";
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		return "<html>" + getPlainDamageDisplay() + "</html>";
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		PowerDialog d = new PowerDialog(this, isNew, isPower);
		d.setSize(d.getSize().width + 100, d.getSize().height);
		return d;
	}

	private String getPlainDamageDisplay() {
		DecimalFormat formatter = new DecimalFormat("#.###E0");
		double g = HeroDesigner.getActiveHero().getWeight() * 453.5924;
		if (HeroDesigner.getInstance().getPrefs().isMetric()) {
			g = HeroDesigner.getActiveHero().getWeight() * 1000;
		}
		if (findObjectByID(getAssignedModifiers(), "NORMALMASS") == null) {
			g = g
					* Math
							.pow(
									massMultiplier,
									((double) getLevels() / (double) getMassMultiplierLevels()));
		}
		BigDecimal wght = new BigDecimal(g / 1000d);
		wght = wght.setScale(4, BigDecimal.ROUND_HALF_UP);
		if (g / 1000d > .00009) {
			formatter = new DecimalFormat("#.####");
		}
		String weight = formatter.format(g / 1000d) + " kg mass, ";
		String str = getStrIncrease() != 0 ? "+"
				+ getStrIncrease()
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) strIncreaseLevels) + " STR" : "";
		int bd = (int) Rounder.roundHalfUp(bodyIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) bodyIncreaseLevels));
		String body = bd != 0 ? "+" + bd + " BODY, " : "";
		int kb = (int) Rounder.roundHalfUp(kbIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) kbIncreaseLevels));
		String kbdec = kb != 0 ? (kb < 0 ? "takes " : "takes +") + kb
				+ "\" KB, " : "";
		if (HeroDesigner.getActiveTemplate().is6E()) {
			kbdec = kb != 0 ? (kb < 0 ? "takes " : "takes +") + kb + "m KB, "
					: "";
		}
		int st = (int) Rounder.roundHalfUp(stunIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) stunIncreaseLevels));
		String stun = st != 0 ? "+" + st + " STUN, " : "";
		int dcv = (int) Rounder.roundHalfUp(dcvIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) dcvIncreaseLevels));
		String DCV = dcv != 0 ? (dcv < 0 ? "" : "+") + dcv + " DCV, " : "";
		int per = (int) Rounder.roundHalfUp(perIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) perIncreaseLevels));
		String PER = per != 0 ? per >= 0 ? "+" : "" + per
				+ " PER Rolls to perceive character, " : "";
		double cm = getLevels() >= getHeightIncreaseLevels() ? HeroDesigner
				.getActiveHero().getHeight()
				* 2.54
				* Math.pow(getHeightIncrease(), (double) getLevels()
						/ (double) heightIncreaseLevels) : HeroDesigner
				.getActiveHero().getHeight() * 2.54;
		if (HeroDesigner.getInstance().getPrefs().isMetric()) {
			cm = getLevels() >= getHeightIncreaseLevels() ? HeroDesigner
					.getActiveHero().getHeight()
					* Math.pow(getHeightIncrease(), (double) getLevels()
							/ (double) heightIncreaseLevels) : HeroDesigner
					.getActiveHero().getHeight();
		}
		double ht = cm / 100;
		double wd = cm / 200;
		formatter = new DecimalFormat("#.###E0");
		BigDecimal hght = new BigDecimal(ht);
		hght = hght.setScale(3, BigDecimal.ROUND_HALF_UP);
		BigDecimal wdth = new BigDecimal(wd);
		wdth = wdth.setScale(3, BigDecimal.ROUND_HALF_UP);
		if (ht > .0009) {
			formatter = new DecimalFormat("#.####");
		}
		String size = formatter.format(ht) + " m tall, ";
		formatter = new DecimalFormat("#.###E0");
		if (wd > .0009) {
			formatter = new DecimalFormat("#.####");
			// size += formatter.format(wd) + " m wide, ";
		}

		int rch = (int) Math.pow(reachIncrease,
				((double) getLevels() / (double) reachIncreaseLevels));
		String reach = rch != 0 ? rch + "\" reach, " : "";

		String ret = size + weight + str + body + stun + PER + DCV + kbdec
				+ reach;
		if (HeroDesigner.getActiveTemplate().is6E()) {
			ret = size + weight + PER + DCV + kbdec;
		}
		ret = ret.substring(0, ret.length() - 2);
		return ret;
	}
}